package com.avaya.ccs.javafxrefclient.request;

import com.avaya.ccs.api.ContactNumberI;
import com.avaya.ccs.api.DestinationI;
import com.avaya.ccs.core.EmailMedia;
import com.avaya.ccs.javafxrefclient.Logger;

public class EmailCallbackRequest extends InteractionRequest {

    private static final Logger LOG = Logger.getLogger(EmailCallbackRequest.class);
    String contactId;
    String callbackDate; 
    String callbackTime; 
    String callbackNote;

    public EmailCallbackRequest(String contactId, String callbackDate, String callbackTime,String callbackNote) {
        super(LOG, contactId);
        this.contactId=contactId;
        this.callbackDate=callbackDate;
        this.callbackTime=callbackTime;
        this.callbackNote=callbackNote;

    }

    /**
     * The call method executes on the outgoingRequest thread
     *
     * @return
     * @throws Exception
     */
    @Override
    protected Object call() throws Exception {
        String methodName = "call() ";
        LOG.trace(methodName + "+");
        ((EmailMedia) getInteraction().getMedia()).reschedule(callbackDate, callbackTime, callbackNote );
        LOG.trace(methodName + "-");
        return null;
    }
}